<?php
/* --------------------------------------------------------------
   DeletedSingleParcelService.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Events;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceId;

/**
 * Class DeletedSingleParcelService
 *
 * @package Gambio\Admin\ParcelService\Events
 */
class DeletedSingleParcelService
{
    /**
     * @var ParcelServiceId
     */
    private $parcelServiceId;
    
    
    /**
     * DeletedSingleParcelServiceEvent constructor.
     *
     * @param ParcelServiceId $parcelServiceId
     */
    private function __construct(ParcelServiceId $parcelServiceId)
    {
        $this->parcelServiceId = $parcelServiceId;
    }
    
    
    /**
     * @param ParcelServiceId $parcelServiceId
     *
     * @return DeletedSingleParcelService
     */
    public static function create(ParcelServiceId $parcelServiceId): DeletedSingleParcelService
    {
        return new self($parcelServiceId);
    }
    
    
    /**
     * @return ParcelServiceId
     */
    public function parcelServiceId(): ParcelServiceId
    {
        return $this->parcelServiceId;
    }
}